require( "quest/mg_aerobics/convout.lua" );
combine_speech_tables();

round_num = 
{
	6, -- round one
};

initial_setup = true;
show_activity_text = false;

local pathSpeed = 0.927; -- Okay, so higher values mean more ticks between actions so a slower speed, smaller is faster.
local numActionsInRoutine = 0;
local numActionsPerformed = 0;
local currentRoutine = { };
local currentRoutineResponse = { };
local numTicksBetweenActions = 0;
local goodClick = false;
local targetScore = 0;
local currentScore = 0;
local exMoves = 0;
local goodMoves = 0;
local missedMoves = 0;
local segments = { };
local lastMoveIndex = 0;

local nowhere = { x = 1000, y = 1000 };
local pathY = 0;
local pathX = 870+58-115;
local pathXSpace = -115;

-- max number of actions is currently 60, min number is 8
-- 8 actions on screen at once
local pathNodes = 
{
--[[
	-- Note: current action to be performed is placed at the position specified here as index 3
	{ x = 1130, y = 12 }; { x = 910, y = 12 }; { x = 670, y = 12 }; { x = 440, y = 12 }; { x = 210, y = 12 }; { x = 95, y = 12 }; 
	{ x = -15, y = 12 }; { x = -135, y = 12 }; { x = -250, y = 12 }; { x = -365, y = 12 };
	
	{ x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
	{ x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; { x = -395, y = 12 }; 
]]--
	-- Note: current action to be performed is placed at the position specified here as index 2
	{ x = pathX+(pathXSpace*0), y = pathY }; { x = pathX+(pathXSpace*1), y = pathY }; { x = pathX+(pathXSpace*2), y = pathY }; { x = pathX+(pathXSpace*3), y = pathY }; { x = pathX+(pathXSpace*4), y = pathY }; { x = pathX+(pathXSpace*5), y = pathY }; 
	{ x = pathX+(pathXSpace*6), y = pathY }; { x = pathX+(pathXSpace*7), y = pathY }; { x = pathX+(pathXSpace*8), y = pathY }; { x = pathX+(pathXSpace*9), y = pathY }; { x = pathX+(pathXSpace*10), y = pathY }; { x = pathX+(pathXSpace*11), y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
	{ x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; { x = -165, y = pathY }; 
};

local actions =
{
	blue = { image = "circle_blue", index = 7 };
	cyan = { image = "circle_cyan", index = 6 };
	green = { image = "circle_green", index = 5 };
	orange = { image = "circle_orange", index = 3 };
	pink = { image = "circle_pink", index = 2 };
	purple = { image = "circle_purple", index = 8 };
	red = { image = "circle_red", index = 1 };
	yellow = { image = "circle_yellow", index = 4 };	
	none = { image = "spacer" };
};

local resultStrings = 
{
	success = "That was a wonderful routine\n\n";
	failure = "That routine didn't go over very well\n\n";
	exMoves = " Excellent Moves     ";
	goodMoves = " Good Moves     ";
	missedMoves = " Missed Moves     ";
	total = "Total    ";
	beat = "We beat our goal of ";
	missed = "We missed our goal of ";
}

-- these determine the order in which the actions must be performed
local routines = 
{


	--activity 1
	{
		length = 36;
		targetScore = 180;
		lastMove = 35;
		actions = 
			{ 
				"none", "none", "none", "none", "none", "none", "pink", "none", 
				"pink", "none", "blue", "none", "blue", "none", "orange", 
				"none", "orange", "none", "cyan", "none", "cyan", "none", 
				"red", "none", "red", "none", "green", "none",
				"green", "none", "purple", "none", "purple", "none", 
				"pink", "none"
			};
	};
	--activity 2
	{
		length = 46;
		targetScore = 280;
		lastMove = 44;
		actions = 
			{ 
				"none", "none", "none", "none", "blue", "blue", "none", 
				"yellow", "yellow", "none", "red", "red", "none","blue", 
				"blue", "none", "none", "red", 
				"none", "red", "blue", "yellow", "none", "yellow",
				"blue", "red", "none", "red", "blue", 
				"yellow", "none", "none", "none", "red", "red", "none", "yellow", 
				"yellow", "none", "blue", "blue", "none", "yellow", "yellow", "none", "none"
			};
	};	
	--activity 3
	{
		length = 51;
		targetScore = 370;
		lastMove = 50;
		actions = 
			{ 
				"none", "none", "none", "none", "none", "red", "green", 
				"none", "red", "green", "orange", "none", "none", "red", 
				"green", "none", "red", "green", "blue", "none", "none", 
				"yellow", "purple", "none", "yellow", "purple", "pink",
				"none", "none", "yellow", "purple", "none", "yellow", "purple", 
				"cyan", "none", "red", "green", "none", "red", "green", "orange", "none", "none", "red", 
				"green", "none", "red", "green", "blue", "none"
			};
	};


	--activity 4
	{
		length = 54;
		targetScore = 400;
		lastMove = 53;
		actions = 
			{ 
				"none", "none", "none", "none", "pink", "red", "none", 
				"cyan", "green", "none", "yellow", "orange", "none", "purple", 
				"blue", "yellow", "orange", "none", "none", "pink", "red", 
				"none", "cyan", "green", "none", "yellow", "orange",
				"none", "purple", "blue", "yellow", "orange", "none", "none", 
				"pink", "red", "pink", "cyan", "green", "cyan", "none", 
				"none", "yellow", "orange", "yellow", "purple", "blue", "purple", 
				"none", "none", "pink", "red", "pink", "none"
			};
	};
	--activity 5
	{
		length = 52;
		targetScore = 400;
		lastMove = 51;
		actions = 
			{ 
				"none", "none", "none", "none", "none", "purple", "orange", 
				"purple", "yellow", "none", "none", "red", "cyan", "red", 
				"green", "none", "none", "purple", "orange", "purple", "yellow", 
				"none", "none", "red", "cyan", "red", "green",
				"none", "none", "purple", "yellow", 
				"purple", "orange", "none", "none", "red", "green", "red", 
				"cyan", "none", "none", "purple", "yellow", "purple", "orange", 
				"none", "none", "red", "cyan", "red", "green", "none"
			};
	};
	--activity 6
	{
		length = 55;
		targetScore = 560;
		lastMove = 54;
		actions = 
			{ 
				"none", "none", "none", "none", "pink", "blue", "green", 
				"pink", "blue", "green", "none", "purple", "cyan", "orange", 
				"purple", "cyan", "orange", "none", "pink", "blue", "green", 
				"pink", "blue", "green", "none", "purple", "cyan",
				"orange", "purple", "cyan", "orange", "none", "pink", "blue", 
				"pink", "green", "pink", "blue", "pink", "green", "none", 
				"purple", "cyan", "purple", "orange", "purple", "cyan", "purple", 
				"orange", "none", "pink", "blue", "green", "pink", "none"
			};
	};
};

local actionCircle = 
{
	--offset = { x = 494, y = 133 };
	offset = { x = 0, y = 0 };
	backgroundImage = "chartback";
	images = { "chartred", "chartpink", "chartorange", "chartyellow", "chartgreen", "chartcyan", "chartblue", "chartpurple" };
	colours = { "red", "pink", "orange", "yellow", "green", "cyan", "blue", "purple" };
	--[[
	positions = { 
				{ x = 17, y = 55 }, { x = 56, y = 15 }, { x = 150, y = 15 }, { x = 150, y = 56 }, 
				{ x = 149, y = 152 }, { x = 149, y = 153 }, { x = 58, y = 153 }, { x = 18, y = 153 }
			};
	--]]
	positions = { 
				{ x = 0, y = 0 }, { x = 0, y = 0 }, { x = 0, y = 0 }, { x = 0, y = 0 }, 
				{ x = 0, y = 0 }, { x = 0, y = 0 }, { x = 0, y = 0 }, { x = 0, y = 0 }
			};
};

local praise =
{
	good = { offset = { x = 460, y = 127 }, message = "text_good" };
	great = { offset = { x = 460, y = 127 }, message = "text_great" };
	miss = { offset = { x = 460, y = 127 }, message = "text_oops" };
};

local hitZoneInfo = 
{
	offset = { x = 638, y = 0 };
	image = "hitzone";
	highlight = "hitzone_highlight";
};

local menuInfo = 
{
	image = "dialog";
	offset = { x = 25, y = 0 };
	optionOffsets = { { x = 490, y = 95 }, { x = 200, y = 95 }, { x = 487, y = 156 } };
	menuText = 
	{
		{ position = { x = 160, y = 60 }, size = 45, halign = HALIGN.CENTER, color = { a = 1, r = 0.3, g = 0, b = 0 } }, -- title
		{ position = { x = 160, y = 115 }, size = 25, halign = HALIGN.CENTER, color = { a = 1, r = 0, g = 0, b = 0 } }, -- round
		{ position = { x = 100, y = 162 }, size = 20, halign = HALIGN.CENTER, color = { a = 1, r = 0.3, g = 0, b = 0 } }, -- praise
		
		{ position = { x = 275, y = 220 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- excellent moves
		{ position = { x = 275, y = 260 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- good moves
		{ position = { x = 275, y = 305 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- missed moves
		{ position = { x = 275, y = 350 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- total score
		
		{ position = { x = 500, y = 220 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- excellent points
		{ position = { x = 500, y = 260 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- good points
		{ position = { x = 500, y = 305 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- missed points
		{ position = { x = 500, y = 350 }, size = 20, halign = HALIGN.LEFT, color = { a = 1, r = 0, g = 0, b = 0 } }, -- total points
		
		{ position = { x = 160, y = 400 }, size = 20, halign = HALIGN.CENTER, color = { a = 1, r = 0, g = 0, b = 0 } }, -- goal text
	};
	images = { "nextLevel", "playAgain", "watchRoutine" };
};

local scoreInfo = 
{
	offset = { x = 500, y = 440 };
};

local instructorInfo = 
{
	offset = { x = 290, y = 481 };
	anim_table = { "anim/mg_aerobics/instructor1", "anim/mg_aerobics/instructor2", "anim/mg_aerobics/instructor3", "anim/mg_aerobics/instructor4",
			       "anim/mg_aerobics/instructor5", "anim/mg_aerobics/instructor6", "anim/mg_aerobics/instructor7", "anim/mg_aerobics/instructor8",
			       "anim/mg_aerobics/instructorc", "anim/mg_aerobics/instructors"
			    };
};

local studentsInfo = 
{
	-- first student
	{
		offset = { x = 436, y = 379 };
		anim_table = 
				{ 
					"anim/mg_aerobics/student_a1", "anim/mg_aerobics/student_a2", "anim/mg_aerobics/student_a3", "anim/mg_aerobics/student_a4",
					"anim/mg_aerobics/student_a5", "anim/mg_aerobics/student_a6", "anim/mg_aerobics/student_a7", "anim/mg_aerobics/student_a8",
					"anim/mg_aerobics/student_as"
				};				
	},
	-- second student
	{
		offset = { x = 147, y = 371 };
		anim_table = 
				{ 
					"anim/mg_aerobics/student_b1", "anim/mg_aerobics/student_b2", "anim/mg_aerobics/student_b3", "anim/mg_aerobics/student_b4",
					"anim/mg_aerobics/student_b5", "anim/mg_aerobics/student_b6", "anim/mg_aerobics/student_b7", "anim/mg_aerobics/student_b8",
					"anim/mg_aerobics/student_bs"
				};				
	},
	--[[
	-- third student
	{
		offset = { x = 500, y = 395 };
		anim_table = 
				{ 
					"anim/mg_aerobics/student1", "anim/mg_aerobics/student2", "anim/mg_aerobics/student3", "anim/mg_aerobics/student4",
					"anim/mg_aerobics/student5", "anim/mg_aerobics/student6", "anim/mg_aerobics/student7", "anim/mg_aerobics/student8",
					"anim/mg_aerobics/students"
				};				
	}
	--]]
};

local timerInfo = 
{
	offset = { x = 30, y = 90 };
	image = "";
}

local lastMoveInfo = 
{
	offset = { x = 70, y = 5 };
	message = "text_last_move";
}

local praiseGood = nil;
local praiseGreat = nil;
local praiseMiss = nil;
local hitZone = nil;
local menu = nil;
local menuText1 = nil;
local menuText2 = nil;
local menuText3 = nil;
local menuText4 = nil;
local menuText5 = nil;
local menuText6 = nil;
local menuText7 = nil;
local menuText8 = nil;
local menuText9 = nil;
local menuText10 = nil;
local menuText11 = nil;
local menuText12 = nil;
local menuNextLevel = nil;
local menuPlayAgain = nil;
local menuWatchRoutine = nil;
local goal = nil;
local score = nil;
local score_bg = nil;
local score_fill = nil;
local back = nil;
local instructor = nil;
local students = { };
--local timer = nil;
--local lastMove = nil;

local retry = false;
local nextLevel = false;
local gameOver = false;
local watchRoutine = false;
local playingRoutine = false;

function resetmenu()
	menu = nil;
	menuText1 = nil;
	menuText2 = nil;
	menuText3 = nil;
	menuText4 = nil;
	menuText5 = nil;
	menuText6 = nil;
	menuText7 = nil;
	menuText8 = nil;
	menuText9 = nil;
	menuText10 = nil;
	menuText11 = nil;
	menuText12 = nil;
end

function reset()
	numActionsInRoutine = 0;
	numActionsPerformed = 0;
	currentRoutine = { };
	currentRoutineResponse = { };
	numTicksBetweenActions = 0;
	goodClick = false;
	targetScore = 0;
	currentScore = 0;
	exMoves = 0;
	goodMoves = 0;
	missedMoves = 0;
	lastMoveIndex = 0;
	praiseGood = nil;
	praiseGreat = nil;
	praiseMiss = nil;
	hitZone = nil;
	resetmenu();
	--timer = nil;
	--lastMove = nil;
	menuNextLevel = nil;
	menuPlayAgain = nil;
	menuWatchRoutine = nil;
	goal = nil;
	score = nil;
	score_bg = nil;
	score_fill = nil;
	back = nil;
	instructor = nil;
	students = { };
	segments = { };
end

function levelReset()
	numActionsPerformed = 0;
	numTicksBetweenActions = 0;
	goodClick = false;
	currentScore = 0;
	exMoves = 0;
	goodMoves = 0;
	missedMoves = 0;
	currentRoutineResponse = { };
	for i = 1, numActionsInRoutine do	
		table.insert (currentRoutineResponse, i, false);		
	end
end

function levelWatchReset()
	numActionsPerformed = 0;
	numTicksBetweenActions = 0;
end

function ContinuousPathMove( curStep, numSteps )

	if ( curStep < numSteps ) then
		-- move all the actions one step
		for i = 1, numActionsInRoutine do		
			if ( i <= numActionsPerformed ) then
				currentRoutine[i].action:SetAlpha(0);
			else
				local xPos = pathNodes[( i - ( numActionsPerformed - 1 ) )].x + ( ( pathNodes[( i - numActionsPerformed )].x - pathNodes[( i - ( numActionsPerformed - 1 ) )].x ) * ( curStep / numSteps ) );
				local yPos = pathNodes[( i - ( numActionsPerformed - 1 ) )].y + ( ( pathNodes[( i - numActionsPerformed )].y - pathNodes[( i - ( numActionsPerformed - 1 ) )].y ) * ( curStep / numSteps ) );
				currentRoutine[i].action:JumpToPoint { x = xPos, y = yPos };
				currentRoutine[i].action:SetAlpha(1);
			end
		end
	end
end

function spawn_action_circle()
	action_back = get_generic_item_spec( "actionBack" .. tostring( game:Get("mg_aerobics_activity_num") ), actionCircle.backgroundImage, actionCircle["offset"].x, actionCircle["offset"].y);
	back = scene:Spawn(action_back);	
	back:SetAlpha( 1 );
	back:SetDepthValue( 4 );
	for i = 1, 8 do -- 8 actions
		action_segment_spec = get_action_segment_spec(actionCircle["images"][i], actionCircle["images"][i], i, actionCircle["colours"][i] );
		table.insert( segments, i, scene:Spawn(action_segment_spec) );		
	end
end

function dump_action_meshes()
	for i,v in pairs(segments) do
		v:DumpZone();
	end
end

function load_action_meshes()
	for i,v in pairs(segments) do
		v:LoadZone(v.mesh);
	end
end

function spawn_routine_bar()
	for i,v in pairs(routines) do
		if i == game:Get("mg_aerobics_activity_num") then
			numActionsInRoutine = v.length;
			targetScore = v.targetScore;
			lastMoveIndex = v.lastMove;
			for j,w in pairs(v.actions) do
				local action_item_spec = get_action_item_spec( tostring(j) .. tostring( game:Get("mg_aerobics_activity_num") ), actions[w].image, j, w);
				table.insert (currentRoutine, j, { colour = w, index = j, action = scene:Spawn(action_item_spec) });	
				table.insert (currentRoutineResponse, j, false);					
			end
		end
	end
end

function spawn_menu()
	item_spec = get_generic_item_spec( "menu" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.image, menuInfo["offset"].x, menuInfo["offset"].y );
	menu = scene:Spawn(item_spec);	
	menu:SetDepthValue( 10 );
	menuText1 = scene:Spawn(get_menu_text_spec( "menuText1" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[1] ));
	menuText2 = scene:Spawn(get_menu_text_spec( "menuText2" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[2] ));
	menuText3 = scene:Spawn(get_menu_text_spec( "menuText3" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[3] ));
	menuText4 = scene:Spawn(get_menu_text_spec( "menuText4" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[4] ));
	menuText5 = scene:Spawn(get_menu_text_spec( "menuText5" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[5] ));
	menuText6 = scene:Spawn(get_menu_text_spec( "menuText6" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[6] ));
	menuText7 = scene:Spawn(get_menu_text_spec( "menuText7" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[7] ));
	menuText8 = scene:Spawn(get_menu_text_spec( "menuText8" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[8] ));
	menuText9 = scene:Spawn(get_menu_text_spec( "menuText9" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[9] ));
	menuText10 = scene:Spawn(get_menu_text_spec( "menuText10" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[10] ));
	menuText11 = scene:Spawn(get_menu_text_spec( "menuText11" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[11] ));
	menuText12 = scene:Spawn(get_menu_text_spec( "menuText12" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo.offset, menuInfo.menuText[12] ));
	--item_spec = get_nextlevel_item_spec( "nextlevel" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo["images"][1], menuInfo["offset"].x + menuInfo["optionOffsets"][1].x, menuInfo["offset"].y + menuInfo["optionOffsets"][1].y );
	--menuNextLevel = scene:Spawn(item_spec);
	--menuNextLevel = spawn_button(next_level_button_spec);
	--menuNextLevel:JumpToPoint( nowhere );
	--item_spec = get_playagain_item_spec( "playagain" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo["images"][3], menuInfo["offset"].x + menuInfo["optionOffsets"][3].x, menuInfo["offset"].y + menuInfo["optionOffsets"][3].y );
	--menuPlayAgain = scene:Spawn(item_spec);
	menuPlayAgain = spawn_button(play_again_spec);
	menuPlayAgain:JumpToPoint( nowhere );
	--item_spec = get_watchroutine_item_spec( "watchroutine" .. tostring( game:Get("mg_aerobics_activity_num") ), menuInfo["images"][2], menuInfo["offset"].x + menuInfo["optionOffsets"][2].x, menuInfo["offset"].y + menuInfo["optionOffsets"][2].y );
	--menuWatchRoutine = scene:Spawn(item_spec);
	menuWatchRoutine = spawn_button(watch_routine_spec);
	menuWatchRoutine:JumpToPoint( nowhere );
end

function spawn_incidental()
	local item_spec = get_generic_item_spec( "praiseGood" .. tostring( game:Get("mg_aerobics_activity_num") ), "good", 0, 0 );
	praiseGood = scene:Spawn(item_spec);
	item_spec = get_generic_item_spec( "praiseGreat" .. tostring( game:Get("mg_aerobics_activity_num") ), "great", 0, 0 );
	praiseGreat = scene:Spawn(item_spec);	
	item_spec = get_generic_item_spec( "praiseMiss" .. tostring( game:Get("mg_aerobics_activity_num") ), "oops", 0, 0 );
	praiseMiss = scene:Spawn(item_spec);	
	item_spec = get_hitzone_item_spec( "hitZone" .. tostring( game:Get("mg_aerobics_activity_num") ), hitZoneInfo.image, hitZoneInfo["offset"].x, hitZoneInfo["offset"].y );
	hitZone = scene:Spawn(item_spec);
	spawn_menu();
	item_spec = get_goal_spec( "goal" .. tostring( game:Get("mg_aerobics_activity_num") ), "", scoreInfo["offset"].x, scoreInfo["offset"].y );
	goal = scene:Spawn(item_spec);
	goal:SetAlpha( 1 );
	item_spec = get_score_spec( "score" .. tostring( game:Get("mg_aerobics_activity_num") ), "score_bar", 0, 0 );
	score = scene:Spawn(item_spec);	
	score:SetAlpha( 1 );
	item_spec = get_score_bg_spec( "score_bg" .. tostring( game:Get("mg_aerobics_activity_num") ), "score_bar_bg", scoreInfo["offset"].x, scoreInfo["offset"].y );
	score_bg = scene:Spawn(item_spec);	
	score_bg:SetAlpha( 1 );
	item_spec = get_score_fill_spec( "score_fill" .. tostring( game:Get("mg_aerobics_activity_num") ), "score_bar_fill", scoreInfo["offset"].x, scoreInfo["offset"].y );
	score_fill = scene:Spawn(item_spec);	
	score_fill:SetAlpha( 1 );
	UpdateScore();
	--item_spec = get_timer_spec( "timer" .. tostring( game:Get("mg_aerobics_activity_num") ), timerInfo.image, timerInfo["offset"].x, timerInfo["offset"].y );
	--timer = scene:Spawn(item_spec);
	--item_spec = get_generic_item_spec( "lastMove" .. tostring( game:Get("mg_aerobics_activity_num") ), "", lastMoveInfo["offset"].x, lastMoveInfo["offset"].y );
	--lastMove = scene:Spawn(item_spec);
end

function spawn_actors()
	for i = 1, table.getn(studentsInfo) do
		local student_spec = get_student_spec( "student" .. tostring(i), studentsInfo[i].anim_table, studentsInfo[i].offset.x, studentsInfo[i].offset.y );
		table.insert( students, i, scene:Spawn(student_spec) );
		students[i]:PlayAnim( "Stand" );
	end
	local instructor_spec = get_instructor_spec( "instructor", instructorInfo.anim_table, instructorInfo["offset"].x, instructorInfo["offset"].y );
	instructor = scene:Spawn(instructor_spec);
	instructor:PlayAnim( "Stand" );
end

function get_student_spec(_name, _anim, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		anim = _anim;
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			actor:SetDepthValue(3);
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");

			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_timer_spec(_name, _image, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		--anim = _anim;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			--actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_instructor_spec(_name, _anim, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		anim = _anim;
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

watch_routine_spec = 
{
	name = "WATCH_ROUTINE_BUTTON";
	text = "watchroutine";
	halo = "quest/objects/routine_dialog_button";
	position = { x = menuInfo["offset"].x + menuInfo["optionOffsets"][3].x, y = menuInfo["offset"].y + menuInfo["optionOffsets"][3].y };
	image = "routine_dialog_button_watch";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 15,
			x = 0,
			w = 122,
			h = 30,
			bubble = false,
			lineheight = 15,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		HideMenu();						
		levelWatchReset();
		watchRoutine = true;
		safe_kill_actor(scene.HINT_BUTTON);
		if not scene.SKIP_BUTTON then
			spawn_button(skip_button_spec);
		end
	end;
}

skip_button_spec = 
{
	name = "SKIP_BUTTON";
	text = "skip";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530 };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		numActionsPerformed = numActionsInRoutine;
		spawn_button(hint_button_spec);
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		actor:Expire();
	end;
}

play_again_spec = 
{
	name = "PLAY_AGAIN_BUTTON";
	text = "tryagain";
	halo = "quest/objects/routine_dialog_arrow";
	position = { x = menuInfo["offset"].x + menuInfo["optionOffsets"][2].x, y = menuInfo["offset"].y + menuInfo["optionOffsets"][2].y };
	image = "routine_dialog_button_again";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = 0,
			w = 120,
			h = 60,
			bubble = false,
			lineheight = 15,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		HideMenu();
		levelReset();
		UpdateScore();
		retry = true;
	end;
}

next_level_button_spec = 
{
	name = "NEXT_LEVEL_BUTTON";
	text = "next";
	halo = "quest/objects/routine_dialog_arrow";
	position = { x = menuInfo["offset"].x + menuInfo["optionOffsets"][1].x, y = menuInfo["offset"].y + menuInfo["optionOffsets"][1].y };
	image = "routine_dialog_button_next";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = 0,
			w = 120,
			h = 60,
			bubble = false,
			lineheight = 15,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		HideMenu();
		nextLevel = true;
	end;
}

function get_hitzone_item_spec(_name, _image, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			actor:SetDepthValue( 1 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_generic_item_spec(_name, _image, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 0 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_menu_text_spec(_name, position, menuText)
	return
	{
		name = _name;
		
		command = function(actor)
			actor:JumpToPoint { x = position.x, y = position.y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 0 );
			actor:ModifySaySpec
			{
				color = menuText.color,
				y = menuText.position.y,
				x = menuText.position.x,
				lineheight = menuText.size,
				w = 500,
				h = 250,
				bubble = false,
				outline_size = 0,
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.TOP,
				halign = menuText.halign,
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_score_spec(_name, _image, _x, _y)
	return 
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 0 );
			actor:SetDepthValue(3);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 473,
				x = 715,
				w = 60,
				h = 50,
				lineheight = 40,
				bubble = false,
				outline_size = 0,
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.CENTER,
				halign = HALIGN.RIGHT
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_score_bg_spec(_name, _image, _x, _y)
	return 
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetAlpha( 0 );
			actor:SetDepthValue(1);
		end;
	}
end

function get_score_fill_spec(_name, _image, _x, _y)
	return 
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetAlpha( 0 );
			actor:SetDepthValue(2);
		end;
	}
end

function get_goal_spec(_name, _image, _x, _y)
	return 
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 0 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 13,
				x = 100,
				w = 200,
				h = 50,
				lineheight = 20,
				bubble = false,
				outline_size = 0,
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.CENTER,
				halign = HALIGN.LEFT
			};
			actor:Say("text_goal");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function get_action_segment_spec(_name, _image, _index, _colour)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint (GetActionSegmentPosition( _index ));
			--actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			back:SetDepthValue( 5 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.mesh = _image;
			
			actor.on_click = function(flo, item)				
				if ( playingRoutine == false and goodClick == false and numActionsPerformed + 2 <= numActionsInRoutine and _colour == currentRoutine[numActionsPerformed + 2].colour ) then			
					goodClick = true;
				elseif ( playingRoutine == false ) then
					sfx:PlaySFX( "Ummm.ogg", false );
					DoConfused();					
				end
				
				sfx:PlaySFX("audio/sfx/buttonclick");
				actor:LoadImage(_image .. "_down");
				
				actor:StartProc(function(actor) delay(10); actor:LoadImage(_image .. "_rollover"); end);
			end;
			
			actor.point_at_fn = function(actor, enter)
				if enter then
					actor:StartProc(function(actor) actor:LoadImage(_image .. "_rollover"); end);
				else
					actor:StartProc(function(actor) actor:LoadImage(_image); end);
				end
			end;
		end
	}
end

function get_action_item_spec(_name, _image, _index)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint (GetActionItemPosition( _index ));
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( 1 );
			actor:SetDepthValue(2);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			
			actor.on_click = function(flo, item)	
			end;
		end;
	}
end

function GetActionSegmentPosition( index )
	return { x = actionCircle["offset"].x + actionCircle["positions"][index].x, y = actionCircle["offset"].y + actionCircle["positions"][index].y };
end

function GetActionItemPosition( index )
	return pathNodes[index];
end

function Routine()
	scene:SetMusicVolumeTarget(1);
	scene:SetMusicVolumeSpeed(1);
	local aerobics_activity_num = game:Get("mg_aerobics_activity_num");
	
	if playingRoutine == true then
		aerobics_activity_num = aerobics_activity_num - 1;
	end
	
	if  math.mod(aerobics_activity_num, 2) == 0 then
		sfx:PlayMusic ( "audio/music/aerobicsbg2.ogg", true );
	else
		sfx:PlayMusic ( "audio/music/aerobicsbg1.ogg", true );
	end
	
	
	local numTicksBetweenActions = 1;
	while numActionsPerformed <= numActionsInRoutine do
		--UpdateTimer( numTicksBetweenActions );
		if ( goodClick and noClick == false ) then
			currentRoutineResponse[numActionsPerformed] = true;
			DisplayPraise( numTicksBetweenActions );		
			noClick = true;			
			UpdateScore();
		end
		if ( playingRoutine == true and numTicksBetweenActions == math.floor(20*pathSpeed) and currentRoutineResponse[numActionsPerformed] == true ) then
			AnimateGymnasts();
		end
		
		if ( numTicksBetweenActions > 40*pathSpeed ) then		
			if ( numTicksBetweenActions == math.floor(41*pathSpeed) and numActionsPerformed + 2 <= numActionsInRoutine ) then 
				if ( goodClick == false and currentRoutine[numActionsPerformed + 2].colour ~= "none" and playingRoutine == false ) then
					praiseMiss:SetAlpha( 1 );
					praiseMiss:ModifySaySpec
					{
						color = { a = 1, r = 0.15, g = 0.24, b = 0 },
						h = 100,
						w = 100,
						x = praise["miss"]["offset"].x,
						y = praise["miss"]["offset"].y,
						lineheight = 30,
						outline_color = { a = 1, r = 0, g = 0, b = 0 },
						outline_size = 0
					};
					praiseMiss:Say( praise["miss"].message );
					missedMoves = missedMoves + 1;
					sfx:PlaySFX( "Errr.ogg", false );
					DoConfused();
				end
			end
			goodClick = false; -- only one click per action
			noClick = false;
		end
		
		if ( numTicksBetweenActions < 40*pathSpeed and noClick == false and numActionsPerformed + 2 <= numActionsInRoutine and currentRoutine[numActionsPerformed + 2].colour ~= "none") then
			hitZone:LoadImage(hitZoneInfo.highlight);
		else
			hitZone:LoadImage(hitZoneInfo.image);
		end
		
		if ( numTicksBetweenActions > 49*pathSpeed ) then
			HidePraise(); -- that's long enough to tell people how good they are
		end		
		if ( numTicksBetweenActions > 49*pathSpeed ) then
			numActionsPerformed = numActionsPerformed + 1;
			numTicksBetweenActions = 1;
			if ( playingRoutine == false ) then	
				if ( numActionsPerformed + 2 == lastMoveIndex ) then
					--[[lastMove:SetAlpha( 1 );
					lastMove:ModifySaySpec
					{
						color = { a = 1, r = 0.15, g = 0.24, b = 0 },
						h = 100,
						w = 100,
						lineheight = 30,
						outline_color = { a = 1, r = 1, g = 0, b = 0 },
						outline_size = 0
					};
					lastMove:Say( lastMoveInfo.message );
					--]]
					scene:SetMusicVolumeSpeed(0.05);
					scene:SetMusicVolumeTarget(0);
				elseif ( numActionsPerformed + 2 >= lastMoveIndex ) then
					--lastMove:SetAlpha( 0 );
					--lastMove:SayRaw( "" );
				end			
			end
			
			praiseMiss:SetAlpha( 0 );
			praiseMiss:SayRaw( "" );
		end
		ContinuousPathMove( numTicksBetweenActions , 49*pathSpeed ); 
		numTicksBetweenActions = numTicksBetweenActions + 1;
		delay(1);
	end
	hitZone:LoadImage(hitZoneInfo.image);
	scene:SetMusicVolumeSpeed(0.02);
	scene:SetMusicVolumeTarget(0);
end

function UpdateTimer( ticks )	
	local seconds = ( numActionsInRoutine - numActionsPerformed ) - ( ( ticks*pathSpeed * 2 ) / 100 ) + 1.02;
	local minutes = math.floor( seconds / 60 );
	seconds = seconds - ( minutes * 60 );
	local zero = "";
	if ( seconds < 10 ) then
		zero = "0";
	end	
	local hundredths = seconds - math.floor( seconds );
	seconds = math.floor( seconds );
	hundredths = math.floor( hundredths * 100 );
	local zero2 = "";
	if ( hundredths < 10 ) then
		zero2 = "0";
	end		
	timer:SayRaw( tostring( minutes ) .. ":" .. zero .. tostring( seconds ) .. "." .. zero2 .. tostring( hundredths ) );
end

function DoConfused()
	instructor:PlayAnim( "Confused" );
end

function DisplayPraise( ticks )
	if ( ticks > 10*pathSpeed and ticks < 30*pathSpeed ) then
		praiseGreat:SetAlpha( 1 );
		praiseGreat:ModifySaySpec
		{
			color = { a = 1, r = 0.15, g = 0.24, b = 0 },
			h = 100,
			w = 100,
			x = praise["great"]["offset"].x,
			y = praise["great"]["offset"].y,
			lineheight = 30,
			outline_color = { a = 1, r = 1, g = 0.5, b = 0 },
			outline_size = 0
		};
		praiseGreat:Say( praise["great"].message );
		currentScore = currentScore + 15;
		exMoves = exMoves + 1;
		AnimateGymnasts();
	elseif ( ticks > 0*pathSpeed and ticks < 40*pathSpeed ) then
		praiseGood:SetAlpha( 1 );
		praiseGood:ModifySaySpec
		{
			color = { a = 1, r = 0.15, g = 0.24, b = 0 },
			h = 100,
			w = 100,
			x = praise["good"]["offset"].x,
			y = praise["good"]["offset"].y,
			lineheight = 30,
			outline_color = { a = 1, r = 0.5, g = 0.5, b = 1 },
			outline_size = 0
		};
		praiseGood:Say( praise["good"].message );
		currentScore = currentScore + 10;
		goodMoves = goodMoves + 1;
		AnimateGymnasts();		
	end
	sfx:PlaySFX( "correctAction.ogg", false );
end

function AnimateGymnasts()
	local index = actions[currentRoutine[numActionsPerformed + 2].colour].index;	
	for i = 1, table.getn(studentsInfo) do
		students[i]:PlayAnim( "Action" .. tostring(index) );
	end
	instructor:PlayAnim( "Action" .. tostring(index) );
end

function HidePraise()
	praiseGreat:SetAlpha( 0 );
	praiseGreat:SayRaw( "" );
	praiseGood:SetAlpha( 0 );
	praiseGood:SayRaw( "" );
end

function DisplayResults()	
	menu:SetAlpha( 1 );
	menuText1:SetAlpha( 1 );
	menuText2:SetAlpha( 1 );
	menuText3:SetAlpha( 1 );
	menuText4:SetAlpha( 1 );
	menuText5:SetAlpha( 1 );
	menuText6:SetAlpha( 1 );
	menuText7:SetAlpha( 1 );
	menuText8:SetAlpha( 1 );
	menuText9:SetAlpha( 1 );
	menuText10:SetAlpha( 1 );
	menuText11:SetAlpha( 1 );
	menuText12:SetAlpha( 1 );
	hitZone:SetAlpha( 0 );
	for i = 1, 8 do
		segments[i]:SetAlpha( 0 );
	end
	back:SetAlpha( 0 );	
	instructor:SetAlpha( 0 );
	--timer:SetAlpha( 0 );
	--timer:SayRaw( "" ); -- placeholder
	goal:SetAlpha( 0 );
	goal:SayRaw( "" );
	score:SetAlpha( 0 );
	score_bg:SetAlpha( 0 );
	score_fill:SetAlpha( 0 );
	score:SayRaw( "" );
	sfx:PlaySFX("audio/sfx/checklist_zoom1.ogg");
	for i = 1, table.getn(studentsInfo) do
		students[i]:SetAlpha( 0 );
	end
	if ( currentScore >= targetScore ) then
		-- pass		
		sfx:PlaySFX( "Cheer.ogg", false );
		menuNextLevel = spawn_button(next_level_button_spec);
		--menuNextLevel:SetAlpha( 1 );		
		--menuNextLevel:JumpToPoint( next_level_button_spec.position );
		menuWatchRoutine:SetAlpha( 1 );		
		menuWatchRoutine:JumpToPoint( watch_routine_spec.position );
		DisplaySuccess();
	else
		-- fail
		sfx:PlaySFX( "Grumble.ogg", false );
		menuPlayAgain:SetAlpha( 1 );
		menuPlayAgain:JumpToPoint( play_again_spec.position );
		DisplayFailure();
	end	
end

function DisplaySuccess()
	menuText1:Say("activity_title");
	menuText2:SayRaw(scene:grabformattedstring("activity_level", { game:Get("mg_aerobics_activity_num")-1 }));
	
	if currentScore <= (targetScore*1.1) then
		menuText3:Say("activity_passed_1");
	elseif goodMoves == 0 and missedMoves == 0 then -- got all excellent moves
		menuText3:Say("activity_passed_3");
	else
		menuText3:Say("activity_passed_2");
	end
	menuText4:SayRaw(scene:grabformattedstring("activity_excellent_moves", { exMoves }));
	menuText5:SayRaw(scene:grabformattedstring("activity_good_moves", { goodMoves }));
	menuText6:SayRaw(scene:grabformattedstring("activity_missed_moves", { missedMoves }));
	menuText7:Say("activity_total");
	
	menuText8:SayRaw("+" .. (exMoves*15));
	menuText9:SayRaw("+" .. (goodMoves*10));
	menuText10:SayRaw("+0");
	menuText11:SayRaw("=" .. currentScore);
	
	menuText12:SayRaw(scene:grabformattedstring("activity_beat_goal", { targetScore }));
	--[[
	local result = resultStrings.success .. "\n" .. tostring(exMoves) .. 
				resultStrings.exMoves .. "+" .. tostring(exMoves * 15) .. 
				"\n\n" .. tostring(goodMoves) .. resultStrings.goodMoves .. 
				"+" .. tostring(goodMoves * 10) .. "\n\n" .. tostring(missedMoves) .. resultStrings.missedMoves .. 
				"+0" .. "\n\n" .. resultStrings.total .. tostring(currentScore) .. 
				"\n\n" .. resultStrings.beat .. tostring(targetScore) .. "!";
	menu:SayRaw(result);
	--]]
end

function DisplayFailure()
	menuText1:Say("activity_title");
	menuText2:SayRaw(scene:grabformattedstring("activity_level", { game:Get("mg_aerobics_activity_num") }));
	menuText3:Say("activity_failed");
	
	menuText4:SayRaw(scene:grabformattedstring("activity_excellent_moves", { exMoves }));
	menuText5:SayRaw(scene:grabformattedstring("activity_good_moves", { goodMoves }));
	menuText6:SayRaw(scene:grabformattedstring("activity_missed_moves", { missedMoves }));
	menuText7:Say("activity_total");
	
	menuText8:SayRaw("+" .. (exMoves*15));
	menuText9:SayRaw("+" .. (goodMoves*10));
	menuText10:SayRaw("+0");
	menuText11:SayRaw("=" .. currentScore);
	
	menuText12:SayRaw(scene:grabformattedstring("activity_failed_goal", { targetScore }));
	--[[
	local result = resultStrings.failure .. tostring(exMoves) .. 
				resultStrings.exMoves .. "+" .. tostring(exMoves * 15) .. 
				"\n\n" .. tostring(goodMoves) .. resultStrings.goodMoves .. 
				"+" .. tostring(goodMoves * 10) .. "\n\n" .. tostring(missedMoves) .. resultStrings.missedMoves .. 
				"+0" .. "\n\n" .. resultStrings.total .. tostring(currentScore) .. 
				"\n\n" .. resultStrings.missed .. tostring(targetScore) .. ".";
	menu:SayRaw(result);
	--]]
end

function HideMenu()
	menu:SetAlpha( 0 );
	menuText1:SetAlpha( 0 );
	menuText2:SetAlpha( 0 );
	menuText3:SetAlpha( 0 );
	menuText4:SetAlpha( 0 );
	menuText5:SetAlpha( 0 );
	menuText6:SetAlpha( 0 );
	menuText7:SetAlpha( 0 );
	menuText8:SetAlpha( 0 );
	menuText9:SetAlpha( 0 );
	menuText10:SetAlpha( 0 );
	menuText11:SetAlpha( 0 );
	menuText12:SetAlpha( 0 );
	menuText1:SayRaw( "" );
	menuText2:SayRaw( "" );
	menuText3:SayRaw( "" );
	menuText4:SayRaw( "" );
	menuText5:SayRaw( "" );
	menuText6:SayRaw( "" );
	menuText7:SayRaw( "" );
	menuText8:SayRaw( "" );
	menuText9:SayRaw( "" );
	menuText10:SayRaw( "" );
	menuText11:SayRaw( "" );
	menuText12:SayRaw( "" );
	hitZone:SetAlpha( 1 );
	for i = 1, 8 do
		segments[i]:SetAlpha( 1 );
	end
	back:SetAlpha( 1 );
	instructor:SetAlpha( 1 );
	--timer:SetAlpha( 1 );
	goal:SetAlpha( 1 );
	score:SetAlpha( 1 );
	score_bg:SetAlpha( 1 );
	score_fill:SetAlpha( 1 );
	for i = 1, table.getn(studentsInfo) do
		students[i]:SetAlpha( 1 );
	end
	--menuNextLevel:SetAlpha( 0 );
	--menuNextLevel:SayRaw( "" );
	--menuNextLevel:JumpToPoint( nowhere );
	safe_kill_actor(menuNextLevel);
	menuWatchRoutine:SetAlpha( 0 );		
	menuWatchRoutine:JumpToPoint( nowhere );
	menuWatchRoutine:SayRaw( "" );
	menuPlayAgain:SetAlpha( 0 );
	menuPlayAgain:JumpToPoint( nowhere );
	menuPlayAgain:SayRaw( "" );
	
	sfx:PlaySFX("audio/sfx/checklist_zoom2.ogg");
end

function UpdateScore()
	local scoreColor = { a = 1, r = 1, g = 0, b = 0 };
	if ( currentScore >= targetScore ) then
		scoreColor	= { a = 1, r = 0, g = 1, b = 0.25 };
	end
	score:ModifySaySpec
	{
		color = scoreColor,
	};
	score:SayRaw( tostring( currentScore ) );
	goal:SayRaw( scene:grabstring("text_goal") .. " " .. tostring(targetScore) );
	local fillScale = currentScore / targetScore;
	
	if fillScale > 1 then
		fillScale = 1;
	end
	
	score_fill:SetScaleX( fillScale );
end

function setup_activity()
	local activityNum = game:Get("mg_aerobics_activity_num");
	local activityRound = game:Get("mg_aerobics_activity_round");
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		coroutine.yield(RESUME.NOW);		
	else
	end

	if activityNum == 1 and activityRound == 1 then
		help_panel_say_raw(scene:grabstring("tutorial_1"));
	else
		help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	if initial_setup == false then
		reset();
		spawn_action_circle();
		spawn_routine_bar();
		spawn_incidental();
		spawn_actors();
	end
	
	initial_setup = false;
	
	Play();
	sfx:KillMusic();
	--goto_scene(flo, "m2_fitness");
end;

function Play()
	while ( gameOver == false ) do
		sfx:PlaySFX( "newRoutine.ogg", false );	
		Routine();
		
		if playingRoutine == false and currentScore >= targetScore then
			activity_passed(scene.FLO);
		end
		
		dump_action_meshes();
		
		DisplayResults();
		-- wait for what to do next
		while ( nextLevel == false and retry == false and watchRoutine == false ) do	
			delay(1);
		end
		if ( retry == true ) then
			retry = false;			
			playingRoutine = false;
			load_action_meshes();
		elseif ( watchRoutine == true ) then 
			watchRoutine = false;
			playingRoutine = true;	
		elseif ( nextLevel == true ) then
			nextLevel = false;
			playingRoutine = false;	
			Cleanup();
			coroutine.yield(RESUME.NOW);
			next_activity(scene.FLO);
			--load_action_meshes();
		end				
	end	
end

function Cleanup()
	praiseGood:Expire();
	praiseGreat:Expire();
	praiseMiss:Expire();
	hitZone:Expire();
	menu:Expire();
	menuText1:Expire();
	menuText2:Expire();
	menuText3:Expire();
	menuText4:Expire();
	menuText5:Expire();
	menuText6:Expire();
	menuText7:Expire();
	menuText8:Expire();
	menuText9:Expire();
	menuText10:Expire();
	menuText11:Expire();
	menuText12:Expire();
	safe_kill_actor(menuNextLevel);
	menuPlayAgain:Expire();
	menuWatchRoutine:Expire();
	score:Expire();
	score_bg:Expire();
	score_fill:Expire();
	goal:Expire();
	back:Expire();
	--timer:Expire();
	--lastMove:Expire();
	instructor:Expire();
	for i = 1, table.getn(studentsInfo) do
		students[i]:Expire(0);
	end
	for i = 1, 8 do
		segments[i]:Expire(0);
	end
end

function next_activity(flo)
	local activityNum = game:Get("mg_aerobics_activity_num");
	local activityRound = game:Get("mg_aerobics_activity_round");
	local roundComplete = activityRound == 2; -- on next round
	
	if roundComplete then
		gameOver = true;
		goto_scene(flo, "m2_fitness");	
	else
		--scene.NEXT_ACTIVITY_BUTTON:Expire();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
			--spawn_button(fail_activity_button_spec);
		end
		
		--spawn_button(back_button_spec);
		--move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		-- load new puzzle
		setup_activity();
	end
end;

function activity_passed(flo)
	activityComplete = true;
	sfx:PlaySFX( "completeRoutine.ogg", false );
	local activityNum = game:Get("mg_aerobics_activity_num");
	local activityRound = game:Get("mg_aerobics_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	
	if IsCheatMode() then
		safe_kill_actor(scene.PASS_ACTIVITY_BUTTON);
		--scene.FAIL_ACTIVITY_BUTTON:Expire();
	end
	
	--scene.BACK_BUTTON:Expire();
	--spawn_button(next_activity_button_spec);
	
	if roundComplete then	
		help_panel_say_raw(scene:grabstring("round_complete_" .. tostring(activityRound)));
		if activityRound == 1 then
			game:Set("mg_aerobics_activity_round", 2);
			--game:Set("mg_aerobics_activity_num", 1);
			game:Set("mg_aerobics_activity_num", activityNum + 1);
		end
	else
		help_panel_say_raw(scene:grabstring("activity_complete_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		game:Set("mg_aerobics_activity_num", activityNum + 1);
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

function go_back(flo)
	sfx:KillMusic();
	goto_scene(flo, "m2_fitness");
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		actor:ModifySaySpec(flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;

	on_click = function(actor, flo)
		help_panel_say_raw(scene:grabstring("instructions"));
		return RESPONSE.IGNORE;
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	currentScore = targetScore;
	numActionsPerformed = numActionsInRoutine;
end

start_button_spec = 
{
	name = "START_BUTTON";
	text = "start";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 14,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		scene.SETUP:StartProc(function(setup)
			scene.START_BUTTON:Expire();
			spawn_button(hint_button_spec);
			move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
			setup_activity();
		end);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true);
		
		-- set up for initial play
		if game:Get("mg_aerobics_activity_num") < 1 then
			game:Set("mg_aerobics_activity_num", 1);
		end
		
		if game:Get("mg_aerobics_activity_round") < 1 then
			game:Set("mg_aerobics_activity_round", 1);
		end
		
		reset();
		spawn_action_circle();
		spawn_routine_bar();
		spawn_incidental();
		spawn_actors();
		
		lower_hud();
		
		if game:Get("mg_aerobics_activity_num") == 1 then
			spawn_button(start_button_spec);
		else
			spawn_button(hint_button_spec);
		end
		
		spawn_help_panel();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
		end
		
		if game:Get("mg_aerobics_activity_num") == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			setup_activity();
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		scene_setup,
	};
};
